!  In line 886, a user specified routine for generating a draw from the stationary distribution
! of the relevant diffusion must be programmed. The command in place is working only for the 
! OU process.

       program multivariate
  !     use random
       implicit none
       integer seed,numsteps,n,num_sim_bridges,new,numberit,sp,numanswer,NN

       real, allocatable, dimension(:) :: theta
       real, allocatable, dimension(:) :: T
       real, allocatable, dimension(:) :: x,y,z,muOU
       real, allocatable, dimension(:,:) :: Talpha,Tsigma,CHOL
       real, allocatable, dimension(:,:) :: points
       real, allocatable, dimension(:,:) :: points2
       real, allocatable, dimension(:,:) :: browninc
       real, allocatable, dimension(:,:) :: browninc2
  

	real time_begin,time_end,NR(1001),xn,xout,tol
	real h,xha(0:1000),total_number_rej,rho
    real points10(0:1000000),meanT,mt1,mt2,points1(0:1000000)
	real bb(0:1000000),xj,xnum,var,NormVar(0:1000),coef
	integer i,numrej,j,numsim,meetingpoint,stats,mp,nout,k
    integer numcrossings,crid1,crid2,numexactrej,numaux,ct
    integer burnin, DIM,m,choice,sumrej,nummcmcrej,errorflag
    real startcross,ddelta,alpha,URN,gamma
	character*20 answer,file1,file2,file3,file4,fileout,input
	common seed

! method: time reversing diffusion, m=1, using original brownian inc. though they calc in wrong point, m=0

        m=1
        h=0.001
    	numsteps=1000
        tol=0.05

! Start the random number generator randomly! Commenting out the following line will result
! in the SAME result of simulations when repeating the program. This can be an advantage when
! debugging or annoying if one prefers to see different scenarios.

        call init_random_seed()


        seed=7657463

        numcrossings=0


        allocate(T(5))
        allocate(theta(4))

      

! Read parameters - choose method of entering data

        


1       print*,'input data from file'
        print*,'do not call input file id.dat which will be used by system'



         print*,'input parameter file:'
         read(*,*) input
         call system("rm id.dat")
         open(9,file='id.dat')

         open(3,file=input)
         read(3,*) DIM
         write(9,*) DIM
         print*,'Dimension=',DIM

        allocate(x(DIM))
        allocate(y(DIM))
        allocate(z(DIM))
        allocate(Talpha(DIM,DIM))
        allocate(Tsigma(DIM,DIM))
        allocate(CHOL(DIM,DIM))
        allocate(muOU(DIM))


        read(3,*)(x(i),i=1,DIM)
        print*,'start point:'
        write(*,*)(x(i),i=1,DIM)
        write(9,*)(x(i),i=1,DIM)
        read(3,*)(y(i),i=1,DIM)
        print*,'end point:'
        write(*,*)(y(i),i=1,DIM)
        write(9,*)(y(i),i=1,DIM)
        print*,'Drift matrix:'
        do i=1,DIM
         read(3,*)(Talpha(i,j),j=1,DIM)
         write(*,*)(Talpha(i,j),j=1,DIM)
         write(9,*)(Talpha(i,j),j=1,DIM)
        enddo
        print*,'Diffusion matrix:'
        do i=1,DIM
         read(3,*)(Tsigma(i,j),j=1,DIM)
         write(*,*)(Tsigma(i,j),j=1,DIM)
          write(9,*)(Tsigma(i,j),j=1,DIM)
        enddo
        read(3,*) numberit
        print*,'prescribed number of iterations'
        print*,numberit
        write(9,*) numberit
        read(3,*) numsteps
        print*,'number of step partitions of intervals'
        print*,numsteps
        write(9,*) numsteps
        read(3,*) sp
        print*,'sampling point'
        h=1.0/(1.0*numsteps)
        print*,h*sp
        write(9,*) sp


        allocate(points(0:numsteps,DIM))
        allocate(points2(0:numsteps,DIM))
        allocate(browninc(numsteps,DIM))
        allocate(browninc2(numsteps,DIM))


!        open output file
!        print*,'input name for output file'
!        read(*,*) fileout

        open(2,file='mcmc.dat')     


! Data has been input
! Generate Cholesky decomposition for the OU process N_p(0,1/2 M^{-1})
! Here M=Talpha 
  
        call FINDInv(Talpha, CHOL, DIM, errorflag)
        CHOL=0.5*CHOL
        print*,'Cov mat'
        call printmatrix(DIM,CHOL) 

        call cholesky_sub(CHOL,DIM)
        muOU=0.0

        print*,'mu=',muOU
        print*,'CHOL='
        call printmatrix(DIM,CHOL) 

! Generate first proposal bridge points() by coupling

        call DiffusionBridge(DIM,Talpha,Tsigma,gamma,numsteps,h,tol,x,y,points,numrej,m,browninc,ct)

! With initial proposal, points(), use MCMC to generate an exact bridge. We measure the time
! of execution.

       sumrej=0.0


!      print*,'input (1) for exact MCMC or (2) for approximate'
       read(3,*) numanswer
       write(9,*) numanswer


      if (numanswer==1) then
       print*,'MCMC exact method will be applied'
      else
       if (numanswer==2) then
        print*,'Pseudo MH will be applied'
     else
         if (numanswer==3) then
            print*,'Approximate method will be applied'
         else
            print*,"erratum method to be applied"
      endif
      endif
      endif

      read(3,*) gamma
      print*,'gamma=',gamma

      write(9,*) gamma
      endfile(9)
      close(9)


      read(*,*)

      nummcmcrej=0

      if (numanswer==1) then
      call CPU_TIME(time_begin)
      do i=1,numberit
       call MCMCstep(DIM,Talpha,Tsigma,muOU,CHOL,gamma,numsteps,h,tol,x,y,points,browninc,numrej,m,new)
       sumrej=sumrej+numrej
       write(2,*) (points(sp,j),j=1,DIM)
       if (mod(i,1000)==0)print*,i
       if (new.eq.1) then
        nummcmcrej=nummcmcrej+1
       endif
      enddo
        print*,'number of new bridges in MCMC:',nummcmcrej
      call CPU_TIME(time_end)
      else
       if (numanswer==2) then
         open(9,file='rho.dat')
         NN=1
         call init_pseudoMH(DIM,Talpha,Tsigma,muOU,CHOL,gamma,numsteps,h,tol,x,y,points,browninc,numrej,m,new,rho,NN)
         call CPU_TIME(time_begin)
         do i=1,numberit
          call pseudoMH(DIM,Talpha,Tsigma,muOU,CHOL,gamma,numsteps,h,tol,x,y,points,browninc,numrej,m,new,rho,NN)
          sumrej=sumrej+numrej
          write(2,*) (points(sp,j),j=1,DIM)
          write(9,*) 1.0/(1.0*rho)
          if (mod(i,1)==0)print*,i,nummcmcrej,rho
          if (new.eq.1) then
           nummcmcrej=nummcmcrej+1
          endif
         enddo
       call CPU_TIME(time_end)
      endfile(9)
      close(9)
   else
        if (numanswer==3) then
       call CPU_TIME(time_begin)
       do i=1,numberit
        call DiffusionBridge(DIM,Talpha,Tsigma,gamma,numsteps,h,tol,x,y,points,numrej,m,browninc,ct)
!       call MCMCstep(DIM,Talpha,Tsigma,gamma,numsteps,h,tol,x,y,points,browninc,numrej,m,new)
       sumrej=sumrej+numrej
       write(2,*) (points(sp,j),j=1,DIM)
       if (mod(i,1000)==0)print*,i
       enddo
       call CPU_TIME(time_end)
    else
          print*,"tbd"
       endif
    endif
 endif
 

      endfile(2)
      close(2)



      print*,'time=',time_end-time_begin
      print*,'total number of rejections in bridges',sumrej
      print*,'acceptance ratio (pct) in approx',(100.0*numberit)/(1.0*(sumrej+numberit))
      print*,'number of new bridges via MCMC',nummcmcrej
      print*,'Acceptance ratio (percent) in the MCMC sampler',(100.0*nummcmcrej)/(1.0*numberit)

! Output bridge generated: points(). Plot the result in R.

      print*,' '
      call system("rm bridge.txt")
      file2="bridge.txt"
      open(2,file="bridge.txt")
!      print*,numsteps,h,DIM
      do i=0,numsteps
       write(2,*) i*h,(points(i,j),j=1,DIM)
      enddo
      endfile(2)
      close(2)

      print*,'R program calculating...'

!      call system("R CMD BATCH plotbridge.r oplotbridge.out")
!      call system("open /Applications/Skim.app scatter.pdf marginal1.pdf marginal2.pdf &")

!      call system("R CMD BATCH Rcode/qq.r distance.out")
!      call system("open /Applications/Skim.app qq.pdf &")

!!$      if (numanswer==1) then
!!$      call system("open /Applications/Skim.app qq-1.pdf qq-2.pdf qq-3.pdf qq-4.pdf &")
!!$!      call system("open /Applications/Skim.app level_MCMC.pdf &")
!!$       else
!!$      call system("open /Applications/Skim.app qq-1.pdf qq-2.pdf qq-3.pdf qq-4.pdf &")
!!$!      call system("open /Applications/Skim.app level_curves_approx.pdf &")
!!$      endif

      stop
      end


!  Generic routine to generate a uniform random number. Change the interior of the routine
!  in order to adopt your own method.

      FUNCTION UNIF(IX)
       call random_number(x)
       UNIF=x
      RETURN
      END


!  On increment in a Brownian motion. In dimension DIM, from initial point startx
!  a point endx is generated a time delta ahead. The result endx of the routine is a
!  point delta time ahead in the Brownian motion.

	subroutine BrownianStep(DIM,delta,startx,endx)
	implicit none
        integer DIM,i
	real delta,startx(DIM),endx(DIM),var

        do i=1,DIM
        call normalvar(var)
        endx(i)=startx(i)+sqrt(delta)*var
        enddo

	return
	end

! Brownian motion routine in one dimension

        subroutine BM1(numsteps,delta,points)
        implicit none
        integer i,numsteps
	real delta,points(0:numsteps)
        points(0)=0.0
        do i=1,numsteps
           call BrownianStep(1,delta,points(i-1),points(i))
        enddo
        return
        end



! Generic routine to generate a standard normal variate. Change the interior to
! use a specific method. Box-Muller is used here.

        subroutine normalvar(x)
        real x,u
        integer seed
        common seed
        x=boxmuller(seed)
        return
        end

!  Box-Muller method for generating a normal random variate. Uses seed dummy
!  which is not of any importance unless a method for random number generation
!  in unif is used with a seed (which can be the case). In the default case, unif
!  has seed as an input but does not currently use it.

        function boxmuller(seed)
        integer seed
        real boxmuller,u
        integer iset
        real fac,gset,rsq,v1,v2,unif
        save iset,gset
        data iset/0/

 1      if (iset.eq.0) then
         v1=2.*unif(seed)-1.
         v2=2.*unif(seed)-1.
         rsq=v1**2+v2**2
         if (rsq.ge.1..or.rsq.eq.0)goto 1
         fac=sqrt(-2.*log(rsq)/rsq)
         gset=v1*fac
         boxmuller=v2*fac
         iset=1
        else
         boxmuller=gset
         iset=0
        endif
        return
        end

! Milstein calculates for stepsize delta the next point in a diffusion.
! startx is the current location of the diffusion, alpha=alpha(startx) is
! the drift evaluated at startx and sigma=sigma(startx) is the diffusion
! coefficient at startx. endx is the next point in the diffusion (output).
! alpha and sigma must be available by calling this routine.

      subroutine MilsteinStep(DIM,delta,startx,alpha,sigma,endx,brown)
      implicit none
      integer DIM,i,j
      real delta,startx(DIM),endx(DIM)
      real alpha(DIM),sigma(DIM,DIM),W(DIM),xx(DIM),sum,brown(DIM)

      do i=1,DIM
        xx(i)=0.0
      enddo

      call BrownianStep(DIM,delta,xx,W)

       do i=1,DIM
        sum=0.0
       do j=1,DIM
         sum=sum+sigma(i,j)*W(j)
       enddo
	endx(i)=startx(i)+alpha(i)*delta+sum
        brown(i)=W(i)
      enddo

      return
      end




! Using the Milstein scheme we simulate a diffusion from startx, n steps ahead at
! stepsizes delta. Diffusion depends on external functions alpha and sigma. brownian
! contains the original brownian increments used to construct the diffusion. brownian1
! contains the brownian increments of the inverse process, which is calculated from the
! other endpoint of the discretization interval. "m" is an indicator for whether the
! brownian1 is required since it is heavy to calculate: 1 if require, 0 if not.

      subroutine diffusion(DIM,Talpha,Tsigma,delta,startx,nsteps,points,brownian,m,brownian1)
      implicit none
      integer nsteps,i,j,d,DIM,m,k,errorflag
      real delta,startx(DIM),points(0:nsteps,DIM),y1(DIM),y2(DIM,DIM),x1(DIM),x2(DIM)
      real brownian(nsteps,DIM),brownian1(nsteps,DIM),brown(DIM)
      real Talpha(DIM,DIM),Tsigma(DIM,DIM),invmat(DIM,DIM),v1(DIM),v2(DIM)
! nsteps replaces 10000000
      do i=1,DIM
	points(0,i)=startx(i)
        x1(i)=startx(i)
      enddo

      do i=1,nsteps
       call DriftParameter(DIM,Talpha,x1,y1)
       call DiffusionParameter(DIM,Tsigma,x1,y2)
       call MilsteinStep(DIM,delta,x1,y1,y2,x2,brown)
       do j=1,DIM
       brownian(nsteps+1-i,j)=-brown(j)
       enddo
       do j=1,DIM
        points(i,j)=x2(j)
        x1(j)=x2(j)
       enddo
      enddo


        if (m.eq.1) then
          do i=1,nsteps
           do j=1,DIM
            x1(j)=points(nsteps+1-i,j)
           enddo
           call DriftParameter(DIM,Talpha,x1,y1)
           call DiffusionParameter(DIM,Tsigma,x1,y2)

           call FINDInv(y2, invmat, DIM, errorflag)
           do j=1,DIM
            v1(j)=points(nsteps-i,j)-points(nsteps-i+1,j)-y1(j)*delta
           enddo
           do j=1,DIM
            v2(j)=0.0
            do k=1,DIM
             v2(j)=v2(j)+invmat(j,k)*v1(k)
            enddo
            brownian1(i,j)=v2(j)
           enddo
          enddo
        else
            brownian1(i,j)=brownian(i,j)
        endif
	return
	end


! Evaluates y=mu(x;theta) where theta is a parameter vector of length numpara

      subroutine DriftParameter(DIM,Talpha,x,y)
      implicit none
      integer i,j,DIM
      real Talpha(DIM,DIM),x(DIM),y(DIM),sum
       do i=1,DIM
        sum=0.0
        do j=1,DIM
          sum=sum+Talpha(i,j)*x(j)
        enddo
        y(i)=-sum
       enddo
      return
      end

	subroutine DiffusionParameter(DIM,Tsigma,x,y)
	implicit none
	integer DIM,i,j
	real Tsigma(DIM,DIM),x(DIM),y(DIM,DIM)
         do i=1,DIM
          do j=1,DIM
            y(i,j)=Tsigma(i,j)
          enddo
         enddo
	return
	end


 ! b1 added. It is the brownian increment of the bridge.


    subroutine DiffusionBridge(DIM,Talpha,Tsigma,gamma,nsteps,delta,tol,x,y,points,numrej,m,b1,couplingtime)
	implicit none
      integer DIM,nsteps,i,numrej,j,mp,numsteps,errorflag,k,couplingtime,m
      real points(0:nsteps,DIM),x(DIM),y(DIM),delta,brownian1(nsteps,DIM)
      real points1(0:nsteps,DIM),points2(0:nsteps,DIM),y1(DIM),y2(DIM),yy(DIM),D1(DIM),S1(DIM,DIM)
      real Talpha(DIM,DIM),Tsigma(DIM,DIM),invmat(DIM,DIM),ydiff(DIM)
      real Tsigmax(DIM,DIM),sum,uvect(DIM),unorm,brownian(nsteps,DIM),b1(nsteps,DIM)
      real revdif(0:nsteps,DIM),umatrix(DIM,DIM),browninc(DIM),maxdist(DIM),maxd,tol
      real yinitial(DIM),gamma,bmpoints(0:nsteps),deltaWrev(DIM),Pimatrix(DIM,DIM),D2(DIM)
      real Tsigmax1(DIM,DIM),invmat1(DIM,DIM),term1(DIM),term2(DIM),term3(DIM)
      real Ustart(1),Uvar(1),Wprime(DIM)
      real cc

      numsteps=nsteps
      yy=x
      numrej=0.0

! simulate from y

1     call diffusion(DIM,Talpha,Tsigma,delta,y,numsteps,points1,brownian,m,brownian1)

!  Brownian increments already time reversed from diffusion subroutine
!  assign (b1), increments

      if (m.eq.1) then
       do i=1,numsteps
       do j=1,DIM
       b1(i,j)=brownian1(i,j)
       enddo
      enddo
      else
      do i=1,numsteps
       do j=1,DIM
       b1(i,j)=brownian(i,j)
       enddo
      enddo
      endif



! calculate new diffusion dependent on previous
! for each step calculate transformation

      do j=1,DIM
      points2(0,j)=x(j)
      enddo

! Generate an independent BM in one dimension

      call BM1(nsteps,delta,bmpoints)


! i loop starts

     do i=0,(numsteps-1)

        do j=1,DIM
         y2(j)=points1(numsteps-i,j)
        enddo

        call  DiffusionParameter(DIM,Tsigma,y2, Tsigmax)
        call  DriftParameter(DIM,Talpha,y2,D1)
        call  FINDInv(Tsigmax, invmat, DIM, errorflag)

        do j=1,DIM
          ydiff(j)=points1(numsteps-i-1,j)-points1(numsteps-i,j)-D1(j)*delta
        enddo

        do j=1,DIM
          sum=0.0
         do k=1,DIM
          sum=sum+invmat(j,k)*ydiff(k)
         enddo
          deltaWrev(j)=sum
        enddo

        ! generate Pimatrix


        do j=1,DIM
         y1(j)=points2(i,j)
        enddo

        call  DiffusionParameter(DIM,Tsigma,y1,Tsigmax1)
        call  FINDInv(Tsigmax, invmat1, DIM, errorflag)

        do j=1,DIM
          ydiff(j)=points1(numsteps-i,j)-points2(i,j)
        enddo

        do j=1,DIM
          sum=0.0
         do k=1,DIM
          sum=sum+invmat1(j,k)*ydiff(k)
         enddo
         uvect(j)=sum
        enddo



        sum=0.0
         do j=1,DIM
          sum=sum+uvect(j)*uvect(j)
         enddo
        unorm=sqrt(sum)

        do j=1,DIM
         uvect(j)=uvect(j)/unorm
        enddo

        do j=1,DIM
         do k=1,DIM
          Pimatrix(j,k)=uvect(j)*uvect(k)
         enddo
        enddo


        do j=1,DIM
        do k=1,DIM
          umatrix(j,k)=-(1.0-gamma)*Pimatrix(j,k)
          if (j.eq.k) then
            umatrix(j,k)=umatrix(j,k)+1.0
          endif
        enddo
        enddo

! Multiply on reversed b1-Brownian motion:

        do j=1,DIM
         sum=0.0
         do k=1,DIM
           sum=sum+umatrix(j,k)*deltaWrev(k)
         enddo
         term1(j)=sum
        enddo



        Ustart(1)=0.0

        ! generate independent \Delta B_i normal N(0,delta)
           call BrownianStep(1,delta,Ustart,Uvar)

        do j=1,DIM
         Wprime(j)=term1(j)+sqrt(1-gamma*gamma)*uvect(j)*Uvar(1)
        enddo


        call DriftParameter(DIM,Talpha,y1,D1)
        call  DiffusionParameter(DIM,Tsigma,y1,S1)


        do j=1,DIM
         sum=0.0
         do k=1,DIM
           sum=sum+S1(j,k)*Wprime(k)
         enddo
         points2(i+1,j)=points2(i,j)+D1(j)*delta+sum
        enddo
       enddo



! i loop closed


! check whether the diffusions cross each other
! first time reverse the newly constructed reverse process
! so revdif runs in the same direction as points1

      do i=0,(numsteps-1)
       do j=1,DIM
  	 revdif(i,j)=points1(numsteps-i,j)
       enddo
      enddo


      do i=0,(numsteps-1)
!        do j=1,DIM
!          maxdist(j)=abs(points2(i,j)-revdif(i,j))
!        enddo

        cc=0.0
        do j=1,DIM
         cc=cc+(points2(i,j)-revdif(i,j))*(points2(i+1,j)-revdif(i+1,j))
         maxdist(j)=abs(points2(i,j)-revdif(i,j))
        enddo

        maxd=maxdist(1)

         do j=1,DIM
         if (maxdist(j).gt.maxd) then
            maxd=maxdist(j)
         endif
         enddo

        if ((cc<0.0).and.(maxd.lt.tol)) then
         couplingtime=i
         goto 20
        endif

!        maxd=maxdist(1)

!        do j=1,DIM
!         if (maxdist(j).gt.maxd) then
!           maxd=maxdist(j)
!         endif
!        enddo

!        if (maxd.lt.tol) then
!         couplingtime=i
!         goto 20
!        endif
      enddo

      numrej=numrej+1
      if (mod(numrej,1000)==0)print*,'number of rejections',numrej
      goto 1


! construct bridge


20    do i=0,numsteps
        if (i.le.couplingtime) then
        do j=1,DIM
         points(i,j)=points2(i,j)
        enddo
        else
        do j=1,DIM
          points(i,j)=revdif(i,j)
        enddo
        endif
      enddo

! save the diffusion
!         open(3,file="diffusions.txt")
!         do i=0,numsteps
!          write(3,*) i*delta,points2(i,1),revdif(i,1)
!         enddo
!         endfile(3)
!        close(3)

	return
	end



      subroutine geometric(p,N)
      implicit none
      integer N
      real U,p
      call random_number(U)
      N=1+int(alog(U)/alog(p))+1
      end subroutine geometric


      SUBROUTINE FINDInv(matrix, inverse, n, errorflag)
        IMPLICIT NONE
        !Declarations
        INTEGER, INTENT(IN) :: n
        INTEGER, INTENT(OUT) :: errorflag  !Return error status. -1 for error, 0 for normal
        REAL, INTENT(IN), DIMENSION(n,n) :: matrix  !Input matrix
        REAL, INTENT(OUT), DIMENSION(n,n) :: inverse !Inverted matrix

        LOGICAL :: FLAG = .TRUE.
        INTEGER :: i, j, k, l
        REAL :: m
        REAL, DIMENSION(n,2*n) :: augmatrix !augmented matrix

        !Augment input matrix with an identity matrix
        DO i = 1, n
                DO j = 1, 2*n
                        IF (j <= n ) THEN
                                augmatrix(i,j) = matrix(i,j)
                        ELSE IF ((i+n) == j) THEN
                                augmatrix(i,j) = 1
                        Else
                                augmatrix(i,j) = 0
                        ENDIF
                END DO
        END DO

        !Reduce augmented matrix to upper traingular form
        DO k =1, n-1
                IF (augmatrix(k,k) == 0) THEN
                        FLAG = .FALSE.
                        DO i = k+1, n
                                IF (augmatrix(i,k) /= 0) THEN
                                        DO j = 1,2*n
                                                augmatrix(k,j) = augmatrix(k,j)+augmatrix(i,j)
                                        END DO
                                        FLAG = .TRUE.
                                        EXIT
                                ENDIF
                                IF (FLAG .EQV. .FALSE.) THEN
                                        PRINT*, "Matrix is non - invertible"
                                        inverse = 0
                                        errorflag = -1
                                        return
                                ENDIF
                        END DO
                ENDIF
                DO j = k+1, n
                        m = augmatrix(j,k)/augmatrix(k,k)
                        DO i = k, 2*n
                                augmatrix(j,i) = augmatrix(j,i) - m*augmatrix(k,i)
                        END DO
                END DO
        END DO

        !Test for invertibility
        DO i = 1, n
                IF (augmatrix(i,i) == 0) THEN
                        PRINT*, "Matrix is non - invertible"
                        inverse = 0
                        errorflag = -1
                        return
                ENDIF
        END DO

        !Make diagonal elements as 1
        DO i = 1 , n
                m = augmatrix(i,i)
                DO j = i , (2 * n)
                           augmatrix(i,j) = (augmatrix(i,j) / m)
                END DO
        END DO

        !Reduced right side half of augmented matrix to identity matrix
        DO k = n-1, 1, -1
                DO i =1, k
                m = augmatrix(i,k+1)
                        DO j = k, (2*n)
                                augmatrix(i,j) = augmatrix(i,j) -augmatrix(k+1,j) * m
                        END DO
                END DO
        END DO

        !store answer
        DO i =1, n
                DO j = 1, n
                        inverse(i,j) = augmatrix(i,j+n)
                END DO
        END DO
        errorflag = 0
        END SUBROUTINE FINDinv

        subroutine printmatrix(DIM,mat)
        integer DIM,i,j
        real mat(DIM,DIM)
        print*,' '
        do i=1,DIM
         write(*,*)(mat(i,j),j=1,DIM)
        enddo
        print*,' '
        end subroutine printmatrix

        subroutine printvect(DIM,mat)
        integer DIM,i,j
        real mat(DIM)
        print*,' '
         write(*,*)(mat(j),j=1,DIM)
        print*,' '
        end subroutine printvect




!  MCMCstep performs the MCMC alogorithm - one step - in order to produce an exact bridge.
!  added parameters muOU and CHOL for generating initial point of ptb 

         subroutine MCMCstep(DIM,Talpha,Tsigma,muOU,CHOL,gamma,nsteps,delta,tol,x,y,points,b1,numrej,m,new)
         implicit none
         integer DIM,nsteps,i,ii,numrej,j,mp,numsteps,errorflag,k,ell,couplingtime,m,numsim
         integer new,ct
         real points(0:nsteps,DIM),x(DIM),y(DIM),delta,brownian1(nsteps,DIM),x1(DIM),x2(DIM)
         real points1(0:nsteps,DIM),points2(0:nsteps,DIM),y1(DIM),y2(DIM),yy(DIM),D1(DIM),S1(DIM,DIM)
         real Talpha(DIM,DIM),Tsigma(DIM,DIM),invmat(DIM,DIM),invmat1(DIM,DIM),ydiff(DIM)
         real sum,uvect(DIM),unorm,brownian(nsteps,DIM),b1(nsteps,DIM),b2(nsteps,DIM)
         real revdif(0:nsteps,DIM),Pimatrix(DIM,DIM),browninc(DIM),maxdist(DIM),maxd,tol
         real yinitial(DIM),ptbpoint(DIM),gamma
         real sum1,tildeW(DIM),tildeX(0:nsteps,DIM),Tsigmax1(DIM,DIM),Tsigmax2(DIM,DIM)
         real Uvar(1),term1(DIM),term2(DIM),term3(DIM),umatrix(DIM,DIM)
         real tempvec(DIM),D2(DIM),Ustart(1),cc
         real muOU(DIM),CHOL(DIM,DIM)
         integer method

! method of checking crossing (1) for simple distance check (2) for inner product method for OU

         method=2


! generate initial point of ptb-diffusion, brownian inc of this process is of no importance
! and not to be used so we use the quicker option 0 (not 1) to perform simulation

         call mvnormal_cholesky(muOU,CHOL,DIM,ptbpoint)
         
         ! do j=1,DIM
         ! ptbpoint(j)=points2(nsteps,j)
         ! enddo

! generate ptb diffusion with brownian inc. b1
         do j=1,DIM
          points1(0,j)=ptbpoint(j)      ! points1 equals \tilde{X}
!          x1(j)=ptbpoint(j)
         enddo

! Now generate mirrored diffusion

! ---------------------
        do i=0,(nsteps-1)

        do j=1,DIM
         y1(j)=points(i,j)        ! let y1 denote the point of the proposed bridge (input)
         y2(j)=points1(i,j)       ! let y2 denote the points of the \tilde{X} process
        enddo

        call DiffusionParameter(DIM,Tsigma,y2,Tsigmax2)  ! generate diffusion coefficient at y2
        call DiffusionParameter(DIM,Tsigma,y1,Tsigmax1)  ! generate diffusion coefficient at Z/points
        call DriftParameter(DIM,Talpha,y1,D1)            ! generate drift at y1
        call DriftParameter(DIM,Talpha,y2,D2)            ! generate drift at y2
        call FINDInv(Tsigmax1,invmat1,DIM,errorflag)     ! find inverse sigma at y1


        do j=1,DIM
          ydiff(j)=points(i+1,j)-points(i,j) - D1(j)*delta   ! construct \tilde{W}_i
        enddo

        do j=1,DIM
          sum=0.0
         do k=1,DIM
          sum=sum+invmat1(j,k)*ydiff(k)                   !  generate \tilde{W} at current point
         enddo
          tildeW(j)=sum
        enddo

        ! find u(\tilde{X},Z) at current point


        do j=1,DIM
          sum=0.0
         do k=1,DIM
          sum=sum+invmat1(j,k)*(points1(j,k)-points(j,k))   ! construct u function
         enddo
          uvect(j)=sum
        enddo

        sum=0.0
        do j=1,DIM
          sum=sum+uvect(j)*uvect(j)
        enddo

        unorm=sqrt(sum)

        do j=1,DIM
         uvect(j)=uvect(j)/unorm
        enddo                                                ! u function contructed


        ! construct Pi- matrix = u*u^T


        do j=1,DIM
        do k=1,DIM
          Pimatrix(j,k)=uvect(j)*uvect(k)
        enddo
        enddo

        Ustart(1)=0.0

        ! generate independent U normal N(0,delta)
           call BrownianStep(1,delta,Ustart,Uvar)

        ! construct next point in \tilde{X} -  points1

        do j=1,DIM
           term1(j)=uvect(j)*Uvar(1)*sqrt((1-gamma*gamma))  ! -------------------------
        enddo

        do j=1,DIM
         do k=1,DIM
          if (j==k) then
          umatrix(j,k)=1.0-(1.0-gamma)*Pimatrix(j,k)
          else
          umatrix(j,k)=(gamma-1.0)*Pimatrix(j,k)
          endif
         enddo
        enddo


        do j=1,DIM
         sum=0.0
          do k=1,DIM
           sum=sum+umatrix(j,k)*tildeW(k)
          enddo
         tempvec(j)=sum
        enddo

        do j=1,DIM
         sum=0.0
          do k=1,DIM
           sum=sum+Tsigmax2(j,k)*tempvec(k)
          enddo
         term2(j)=sum
        enddo

        do j=1,DIM
         term3(j)=delta*D2(j)
        enddo


        do j=1,DIM
         points1(i+1,j)=points1(i,j)+term3(j)+term2(j)+term1(j)
        enddo
      enddo

! -----------------------------



! check whether the ptb diffusion crosses the bridge with points()

        if (method==1) then
        do i=0,nsteps
        do j=1,DIM
          maxdist(j)=abs(points(i,j)-points1(i,j))
        enddo

        maxd=maxdist(1)

        do j=1,DIM
         if (maxdist(j).gt.maxd) then
           maxd=maxdist(j)
         endif
        enddo

! The original bridge, points(), is updated if certain criterium is fulfilled:


        if (maxd.lt.tol) then
         new=1
         call DiffusionBridge(DIM,Talpha,Tsigma,gamma,nsteps,delta,tol,x,y,points,numrej,m,b1,ct)
         goto 50
        else
        new=0
        endif
        enddo
          else
         do i=0,(nsteps-1)
           cc=0.0
          do j=1,DIM
           cc=cc+(points(i,j)-points1(i,j))*(points(i+1,j)-points1(i+1,j))
           maxdist(j)=abs(points(i,j)-points1(i,j))
          enddo

         maxd=maxdist(1)

         do j=1,DIM
         if (maxdist(j).gt.maxd) then
           maxd=maxdist(j)
         endif
         enddo

          if ((cc.lt.0).and.(maxd.lt.tol)) then
            new=1
            call DiffusionBridge(DIM,Talpha,Tsigma,gamma,nsteps,delta,tol,x,y,points,numrej,m,b1,ct)
            goto 50
          else
            new=0
          endif
         enddo
        endif
50      end subroutine MCMCstep



            subroutine init_random_seed()
            implicit none
            integer, allocatable :: seed(:)
            integer :: i, n, un, istat, dt(8), pid, t(2), s, getpid
            integer(8) :: count, tms

            call random_seed(size = n)
            allocate(seed(n))
            ! First try if the OS provides a random number generator
            open(newunit=un, file="/dev/urandom", access="stream", &
                 form="unformatted", action="read", status="old", iostat=istat)
            if (istat == 0) then
               read(un) seed
               close(un)
            else
               ! Fallback to XOR:ing the current time and pid. The PID is
               ! useful in case one launches multiple instances of the same
               ! program in parallel.
               call system_clock(count)
               if (count /= 0) then
                  t = transfer(count, t)
               else
                  call date_and_time(values=dt)
                  tms = (dt(1) - 1970) * 365_8 * 24 * 60 * 60 * 1000 &
                       + dt(2) * 31_8 * 24 * 60 * 60 * 1000 &
                       + dt(3) * 24 * 60 * 60 * 60 * 1000 &
                       + dt(5) * 60 * 60 * 1000 &
                       + dt(6) * 60 * 1000 + dt(7) * 1000 &
                       + dt(8)
                  t = transfer(tms, t)
               end if
               s = ieor(t(1), t(2))
               pid = getpid() + 1099279 ! Add a prime
               s = ieor(s, pid)
               if (n >= 3) then
                  seed(1) = t(1) + 36269
                  seed(2) = t(2) + 72551
                  seed(3) = pid
                  if (n > 3) then
                     seed(4:) = s + 37 * (/ (i, i = 0, n - 4) /)
                  end if
               else
                  seed = s + 37 * (/ (i, i = 0, n - 1 ) /)
               end if
            end if
            call random_seed(put=seed)
          end subroutine init_random_seed

          subroutine Vdist(DIM,Vinv,x,y,dist)
          implicit none
          integer DIM,i,j
          real Vinv(DIM,DIM),x(DIM),y(DIM),dist
          dist=0.0
          do i=1,DIM
           do j=1,DIM
            dist=dist+(x(i)-y(i))*Vinv(i,j)*(x(j)-y(j))
           enddo
          enddo
          end subroutine Vdist



         subroutine init_pseudoMH(DIM,Talpha,Tsigma,muOU,CHOL,gamma,nsteps,delta,tol,x,y,points,b1,numrej,m,new,rho,NN)
         implicit none
         integer DIM,nsteps,i,ii,numrej,j,mp,numsteps,errorflag,k,ell,couplingtime,m,numsim
         integer new,ct,num_hit_bridge,nhb,NN
         real points(0:nsteps,DIM),x(DIM),y(DIM),delta,brownian1(nsteps,DIM),x1(DIM),x2(DIM)
         real points1(0:nsteps,DIM),points2(0:nsteps,DIM),y1(DIM),y2(DIM),yy(DIM),D1(DIM),S1(DIM,DIM)
         real Talpha(DIM,DIM),Tsigma(DIM,DIM),invmat(DIM,DIM),invmat1(DIM,DIM),ydiff(DIM)
         real sum,uvect(DIM),unorm,brownian(nsteps,DIM),b1(nsteps,DIM),b2(nsteps,DIM)
         real revdif(0:nsteps,DIM),Pimatrix(DIM,DIM),browninc(DIM),maxdist(DIM),maxd,tol
         real yinitial(DIM),ptbpoint(DIM),gamma,rho,newrho
         real sum1,tildeW(DIM),tildeX(0:nsteps,DIM),Tsigmax1(DIM,DIM),Tsigmax2(DIM,DIM)
         real Uvar(1),term1(DIM),term2(DIM),term3(DIM),umatrix(DIM,DIM)
         real tempvec(DIM),D2(DIM),Ustart(1),cc
         real newpoints(0:nsteps,DIM),newB(nsteps,DIM)
         real geom(NN),acc_prob,uu,muOU(DIM),CHOL(DIM,DIM)

! Simulate new approximate diffusion bridge

         call DiffusionBridge(DIM,Talpha,Tsigma,gamma,nsteps,delta,tol,x,y,points,numrej,m,newB,ct)

! Simulate p_T^*(b)-associated diffusions until input bridge it hit. Count how many simulations
! that take

          ii=1

5        num_hit_bridge=0


10       num_hit_bridge=num_hit_bridge+1

!  change to mvnormal_cholesky here as in MCMCstep
!         call diffusion(DIM,Talpha,Tsigma,delta,y,nsteps,points2,brownian,0,brownian1)
         call mvnormal_cholesky(muOU,CHOL,DIM,ptbpoint)
!         print*,'here0',num_hit_bridge

         ! do j=1,DIM
         ! ptbpoint(j)=points2(nsteps,j)
         ! enddo

! generate ptb diffusion with brownian inc. b1
         do j=1,DIM
          points1(0,j)=ptbpoint(j)      ! points1 equals \tilde{X}
!          x1(j)=ptbpoint(j)
         enddo

! Now generate mirrored diffusion

! ---------------------
        do i=0,(nsteps-1)

        do j=1,DIM
         y1(j)=newpoints(i,j)        ! let y1 denote the point of the new proposed bridge
         y2(j)=points1(i,j)       ! let y2 denote the points of the \tilde{X} process
        enddo

        call DiffusionParameter(DIM,Tsigma,y2,Tsigmax2)  ! generate diffusion coefficient at y2
        call DiffusionParameter(DIM,Tsigma,y1,Tsigmax1)  ! generate diffusion coefficient at Z/points
        call DriftParameter(DIM,Talpha,y1,D1)            ! generate drift at y1
        call DriftParameter(DIM,Talpha,y2,D2)            ! generate drift at y2
        call FINDInv(Tsigmax1,invmat1,DIM,errorflag)     ! find inverse sigma at y1


        do j=1,DIM
          ydiff(j)=points(i+1,j)-points(i,j) - D1(j)*delta   ! construct \tilde{W}_i
        enddo

        do j=1,DIM
          sum=0.0
         do k=1,DIM
          sum=sum+invmat1(j,k)*ydiff(k)                   !  generate \tilde{W} at current point
         enddo
          tildeW(j)=sum
        enddo

        ! find u(\tilde{X},Z) at current point


        do j=1,DIM
          sum=0.0
         do k=1,DIM
          sum=sum+invmat1(j,k)*(points1(j,k)-points(j,k))   ! construct u function
         enddo
          uvect(j)=sum
        enddo

        sum=0.0
        do j=1,DIM
          sum=sum+uvect(j)*uvect(j)
        enddo

        unorm=sqrt(sum)

        do j=1,DIM
         uvect(j)=uvect(j)/unorm
        enddo                                                ! u function contructed


        ! construct Pi- matrix = u*u^T


        do j=1,DIM
        do k=1,DIM
          Pimatrix(j,k)=uvect(j)*uvect(k)
        enddo
        enddo

        Ustart(1)=0.0

        ! generate independent U normal N(0,delta)
           call BrownianStep(1,delta,Ustart,Uvar)

        ! construct next point in \tilde{X} -  points1

        do j=1,DIM
           term1(j)=uvect(j)*Uvar(1)*sqrt((1-gamma*gamma))  ! -------------------------
        enddo

        do j=1,DIM
         do k=1,DIM
          if (j==k) then
          umatrix(j,k)=1.0-(1.0-gamma)*Pimatrix(j,k)
          else
          umatrix(j,k)=(gamma-1.0)*Pimatrix(j,k)
          endif
         enddo
        enddo


        do j=1,DIM
         sum=0.0
          do k=1,DIM
           sum=sum+umatrix(j,k)*tildeW(k)
          enddo
         tempvec(j)=sum
        enddo

        do j=1,DIM
         sum=0.0
          do k=1,DIM
           sum=sum+Tsigmax2(j,k)*tempvec(k)
          enddo
         term2(j)=sum
        enddo

        do j=1,DIM
         term3(j)=delta*D2(j)
        enddo


        do j=1,DIM
         points1(i+1,j)=points1(i,j)+term3(j)+term2(j)+term1(j)
        enddo
      enddo

! -----------------------------



! check whether the ptb diffusion crosses the bridge with points()


         do i=0,(nsteps-1)
           cc=0.0
          do j=1,DIM
           cc=cc+(points(i,j)-points1(i,j))*(points(i+1,j)-points1(i+1,j))
           maxdist(j)=abs(points(i,j)-points1(i,j))
          enddo

         maxd=maxdist(1)

         do j=1,DIM
         if (maxdist(j).gt.maxd) then
           maxd=maxdist(j)
         endif
         enddo

          if ((cc.lt.0).and.(maxd.lt.tol)) then
            geom(ii)=num_hit_bridge
            if (ii.lt.NN) then
            ii=ii+1
            goto 5
            else
            goto 50
            endif
          endif
        enddo
        goto 10



50      newrho=0.0
        do i=1,NN
          print*,'geom',i,geom(i)
          newrho=newrho+geom(i)
        enddo
          rho=newrho/(1.0*NN)



        end subroutine init_pseudoMH


         subroutine pseudoMH(DIM,Talpha,Tsigma,muOU,CHOL,gamma,nsteps,delta,tol,x,y,newpoints,b1,numrej,m,new,rho,NN)
         implicit none
         integer DIM,nsteps,i,ii,numrej,j,mp,numsteps,errorflag,k,ell,couplingtime,m,numsim
         integer new,ct,num_hit_bridge,nhb,NN
         real points(0:nsteps,DIM),x(DIM),y(DIM),delta,brownian1(nsteps,DIM),x1(DIM),x2(DIM)
         real points1(0:nsteps,DIM),points2(0:nsteps,DIM),y1(DIM),y2(DIM),yy(DIM),D1(DIM),S1(DIM,DIM)
         real Talpha(DIM,DIM),Tsigma(DIM,DIM),invmat(DIM,DIM),invmat1(DIM,DIM),ydiff(DIM)
         real sum,uvect(DIM),unorm,brownian(nsteps,DIM),b1(nsteps,DIM),b2(nsteps,DIM)
         real revdif(0:nsteps,DIM),Pimatrix(DIM,DIM),browninc(DIM),maxdist(DIM),maxd,tol
         real yinitial(DIM),ptbpoint(DIM),gamma,rho,newrho
         real sum1,tildeW(DIM),tildeX(0:nsteps,DIM),Tsigmax1(DIM,DIM),Tsigmax2(DIM,DIM)
         real Uvar(1),term1(DIM),term2(DIM),term3(DIM),umatrix(DIM,DIM)
         real tempvec(DIM),D2(DIM),Ustart(1),cc
         real newpoints(0:nsteps,DIM),newB(nsteps,DIM)
         real geom(NN),acc_prob,uu,muOU(DIM),CHOL(DIM,DIM)

! Simulate new approximate diffusion bridge

         call DiffusionBridge(DIM,Talpha,Tsigma,gamma,nsteps,delta,tol,x,y,points,numrej,m,newB,ct)

! Simulate p_T^*(b)-associated diffusions until input bridge it hit. Count how many simulations
! that take

          ii=1

5        num_hit_bridge=0


10       num_hit_bridge=num_hit_bridge+1

!  change to mvnormal_cholesky here as in MCMCstep
!         call diffusion(DIM,Talpha,Tsigma,delta,y,nsteps,points2,brownian,0,brownian1)
         call mvnormal_cholesky(muOU,CHOL,DIM,ptbpoint)
 !        print*,'here1',num_hit_bridge,ii

         ! do j=1,DIM
         ! ptbpoint(j)=points2(nsteps,j)
         ! enddo

! generate ptb diffusion with brownian inc. b1
         do j=1,DIM
          points1(0,j)=ptbpoint(j)      ! points1 equals \tilde{X}
!          x1(j)=ptbpoint(j)
         enddo

! Now generate mirrored diffusion

! ---------------------
        do i=0,(nsteps-1)

        do j=1,DIM
         y1(j)=points(i,j)        ! let y1 denote the point of the new proposed bridge
         y2(j)=points1(i,j)       ! let y2 denote the points of the \tilde{X} process
        enddo

        call DiffusionParameter(DIM,Tsigma,y2,Tsigmax2)  ! generate diffusion coefficient at y2
        call DiffusionParameter(DIM,Tsigma,y1,Tsigmax1)  ! generate diffusion coefficient at Z/points
        call DriftParameter(DIM,Talpha,y1,D1)            ! generate drift at y1
        call DriftParameter(DIM,Talpha,y2,D2)            ! generate drift at y2
        call FINDInv(Tsigmax1,invmat1,DIM,errorflag)     ! find inverse sigma at y1


        do j=1,DIM
          ydiff(j)=points(i+1,j)-points(i,j) - D1(j)*delta   ! construct \tilde{W}_i
        enddo

        do j=1,DIM
          sum=0.0
         do k=1,DIM
          sum=sum+invmat1(j,k)*ydiff(k)                   !  generate \tilde{W} at current point
         enddo
          tildeW(j)=sum
        enddo

        ! find u(\tilde{X},Z) at current point


        do j=1,DIM
          sum=0.0
         do k=1,DIM
          sum=sum+invmat1(j,k)*(points1(j,k)-points(j,k))   ! construct u function
         enddo
          uvect(j)=sum
        enddo

        sum=0.0
        do j=1,DIM
          sum=sum+uvect(j)*uvect(j)
        enddo

        unorm=sqrt(sum)

        do j=1,DIM
         uvect(j)=uvect(j)/unorm
        enddo                                                ! u function contructed


        ! construct Pi- matrix = u*u^T


        do j=1,DIM
        do k=1,DIM
          Pimatrix(j,k)=uvect(j)*uvect(k)
        enddo
        enddo

        Ustart(1)=0.0

        ! generate independent U normal N(0,delta)
           call BrownianStep(1,delta,Ustart,Uvar)

        ! construct next point in \tilde{X} -  points1

        do j=1,DIM
           term1(j)=uvect(j)*Uvar(1)*sqrt((1-gamma*gamma))  ! -------------------------
        enddo

        do j=1,DIM
         do k=1,DIM
          if (j==k) then
          umatrix(j,k)=1.0-(1.0-gamma)*Pimatrix(j,k)
          else
          umatrix(j,k)=(gamma-1.0)*Pimatrix(j,k)
          endif
         enddo
        enddo


        do j=1,DIM
         sum=0.0
          do k=1,DIM
           sum=sum+umatrix(j,k)*tildeW(k)
          enddo
         tempvec(j)=sum
        enddo

        do j=1,DIM
         sum=0.0
          do k=1,DIM
           sum=sum+Tsigmax2(j,k)*tempvec(k)
          enddo
         term2(j)=sum
        enddo

        do j=1,DIM
         term3(j)=delta*D2(j)
        enddo


        do j=1,DIM
         points1(i+1,j)=points1(i,j)+term3(j)+term2(j)+term1(j)
        enddo
      enddo

! -----------------------------



! check whether the ptb diffusion crosses the bridge with points()


         do i=0,(nsteps-1)
           cc=0.0
          do j=1,DIM
           cc=cc+(points(i,j)-points1(i,j))*(points(i+1,j)-points1(i+1,j))
           maxdist(j)=abs(points(i,j)-points1(i,j))
          enddo

         maxd=maxdist(1)

         do j=1,DIM
         if (maxdist(j).gt.maxd) then
           maxd=maxdist(j)
         endif
         enddo


         
        

          if ((cc.lt.0).and.(maxd.lt.tol)) then
            geom(ii)=num_hit_bridge
            if (ii.lt.NN) then
            ii=ii+1
            goto 5
            else
            goto 50
            endif
          endif
        enddo
        goto 10



50      newrho=0.0
        do i=1,NN
          newrho=newrho+1.0*geom(i)
        enddo
          newrho=newrho/(1.0*NN)
 !         print*,'newrho',newrho,rho

        acc_prob=newrho/rho
        if (acc_prob.gt.1) then
          acc_prob=1.0
        endif

!        print*,'acc_prob',acc_prob

        call random_number(uu)

!        print*,'acc_prob',acc_prob

        new=0

        if (acc_prob.gt.uu) then
           rho=newrho
           new=1
           do i=0,nsteps
            do j=1,DIM
              newpoints(i,j)=points(i,j)
            enddo
           enddo
        endif


        end subroutine pseudoMH


subroutine cholesky_sub(A,n)
implicit none
  ! formal vars
integer :: n      ! number of rows/cols in matrix
real    :: A(n,n),L(n,n) ! matrix to be decomposed

! local vars
integer :: i,j    
  ! iteration counter
 ! begin loop
  do j = 1,n

   ! perform diagonal component
   A(j,j) = sqrt(A(j,j) - dot_product(A(j,1:j-1),A(j,1:j-1)))

    ! perform off-diagonal component
    if (j < n) A(j+1:n,j) = (A(j+1:n,j) - matmul(A(j+1:n,1:j-1),A(j,1:j-1))) / &
   &           A(j,j)
  enddo 

do i=1,n
 do j=1,n 
  if (j.gt.i)A(i,j)=0.0
 enddo
enddo    

end subroutine cholesky_sub


subroutine mvnormal_cholesky(mu,L,n,x)
  implicit none
   real :: mu(n),x(n)
   real :: L(n,n)
   integer :: n,i
   do i=1,n
    call normalvar(x(i))
   enddo
   x=MATMUL(L,x)
   x=mu+x
end subroutine mvnormal_cholesky

subroutine mvnormal(mu,sigma,n,x)
  implicit none
  real :: mu(n),x(n)
  real :: sigma(n,n)
  integer :: n,i
  call cholesky_sub(sigma,n)
  call mvnormal_cholesky(mu,sigma,n,x)
end subroutine mvnormal



    

       